///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1040.C - Message 1040 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1040 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"
#include "alm_send.h"

void wait(float);  
void clear_message_line(void);   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1040 message from the ZMsgBuf.
//
void Dec1040(tMSGBUF *ZMsgBuf, tMSG1040 *Msg)
{
  unsigned i=0;
  extern short file_len;
  extern unsigned char filebuff[4000];
  
  //Get WeekNumber and AlmanacData from 1040 and then build 1240 in filebuff for each sv
  file_len = 0;
  memset(&ZMsg.Msg1240, 0, sizeof(ZMsg.Msg1240));
  BldZMsg(ZMsgBuf, ZMsg, 1240);  
  for (i=0; i < sizeof(ZMsg.Msg1240) + HDR_LEN; i++, file_len++)
    filebuff[file_len] = (unsigned char)ZMsgBuf->byte[i];    /* Save Data To File Buffer */
  store_alm(file_len);
  //file_len = 0;
  //clear_message_line();

}                                      

/*  not needed yet                                        
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1040 message in the ZMsgBuf. 
//
void Bld1040(tMSGBUF *ZMsgBuf, tMSG1040 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                        , ZMsgBuf, 1);     // message preamble
   PutShort  (1040                          , ZMsgBuf, 2);     // message number
   PutShort  (16                            , ZMsgBuf, 3);     // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);     // message ack/nack request
 //PutShort  (CheckSum(ZMsgBuf[0], 4)       , ZMsgBuf, 5);     // header check sum
                                                  
 //PutShort  (CheckSum(ZMsgBuf, 6, 12)      , ZMsgBuf,18);     // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display acknowlege of a Zodiac 1040 message from the ZMsgBuf and place data in file.
//
void Show1040(tMSG1040 *Msg)
{
; //whatever
}                                                 
                                      
end not needed yet */                                           
